PSCAD 4.2.0

Settings
 {
 Id = "1019767904.1144433149"
 Author = "Shaahin Filizadeh.jayas"
 Desc = "Golden Section - Minimize Integral Square Error"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 1
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 10
  Step = 0.0005
  Plot = 0.01
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "channel.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }

 }

Definitions
 {
 Component("GoldenOpt_1")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   Category("Main")
    {
    Choice("SM",2,6,142,12,2)
     {
     Style = 0
     Desc = "Search Method"
     Def = "0"
     Len = 15
     *0 = "Interval Search"
     *1 = "Auto Search"
     }
    }
   Category("Interval Search")
    {
    Cond = "SM == 0"
    Input("Vert1",2,2,142,12,2)
     {
     Desc = "Left-hand Point"
     Data = Real
     Len = 6
     Cond = "SM == 0"
     }
    Input("Vert2",2,16,142,12,2)
     {
     Desc = "Right-hand Point"
     Data = Real
     Len = 6
     Cond = "SM == 0"
     }
    Input("Tol1",2,30,142,12,2)
     {
     Desc = "Relative Tolerance"
     Data = Real
     Len = 8
     Cond = "SM == 0"
     }
    }
   Category("Auto Search")
    {
    Cond = "SM == 1"
    Input("StPoint1",2,0,142,12,2)
     {
     Desc = "Starting Point"
     Data = Real
     Len = 6
     Cond = "SM == 1"
     }
    Input("StLength1",2,14,142,12,2)
     {
     Desc = "Initial Step Length"
     Data = Real
     Len = 6
     Cond = "SM == 1"
     }
    Input("StEF1",2,28,142,12,2)
     {
     Desc = "Step Elongation Factor"
     Data = Real
     Len = 6
     Cond = "SM == 1"
     }
    Input("SeIB1",2,42,142,12,2)
     {
     Desc = "Serach Interval Boundary"
     Data = Real
     Len = 6
     Cond = "SM == 1"
     }
    Input("Tol2",2,56,142,12,2)
     {
     Desc = "Relative Tolerance"
     Data = Real
     Len = 6
     Cond = "SM == 1"
     }
    }
   }

  Nodes = 
   {
   Input("input",-54,0)
    {
    Type = Real
    }
   Output("output",54,0)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-29,-29,29,29)
   Pen(ByNode,ByNode,ByNode,input)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Pen(,ByNode,,output)
   Line(54,0,29,0)
   Text(1,4,"GOLDEN")
   }

  Section(EMTDC)
   {
   Fortran = "\
		#SUBROUTINE MY_GOLDEN
		#SUBROUTINE DIRSEA
		
		#FUNCTION INTEGER EMTDC_RUN
	
		#LOCAL INTEGER U_RN !Current Run Number
		#LOCAL INTEGER CURR_FUN !Current function to be run
		#LOCAL REAL VERTEX1
		#LOCAL REAL VERTEX2
		#LOCAL INTEGER LASTRUN
		
		U_RN = EMTDC_RUN()

		#IF SM == 0	
	 	 VERTEX1 = $Vert1
		 VERTEX2 = $Vert2
        	 CALL MY_GOLDEN(VERTEX1,VERTEX2,$Tol1,U_RN,$input,$output)
		#ELSE
		 VERTEX1 = $StPoint1
		 CALL DIRSEA(VERTEX1,$StLength1,$StEF1,$SeIB1,U_RN,CURR_FUN,$input,$output,VERTEX2,LASTRUN)
		 IF (CURR_FUN .EQ. 0 .AND. U_RN .GT. LASTRUN) THEN
	  	  CALL MY_GOLDEN(VERTEX1,VERTEX2,$Tol2,U_RN-LASTRUN,$input,$output)
		 ENDIF
		#ENDIF"
   Branch = ""
   Computations = ""
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144433070
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Portrait,16,[597,467],100)
   {
   0.annotation([198,792],0,0,-1)
    {
    AL1 = "f(x)"
    AL2 = ""
    }
   -Wire-([162,792],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([486,612],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([324,612],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([162,792],0,0,-1)
    {
    Name = "ISE"
    }
   -Wire-([198,612],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.square([378,612],0,0,50)
    {
    Dim = "1"
    }
   0.integral([450,612],0,0,60)
    {
    Extrn = "0"
    Reset = "0"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "1 [s]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "100.0"
    YLo = "-100.0"
    }
   0.datalabel([216,612],4,0,-1)
    {
    Name = "u"
    }
   0.datalabel([486,612],0,0,-1)
    {
    Name = "ISE"
    }
   -Wire-([216,612],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.pgb([216,666],0,24902888,80)
    {
    Name = "applied voltage"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "2.0"
    }
   0.pgb([504,612],0,24906040,70)
    {
    Name = "objective function"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "10"
    }
   -Wire-([324,342],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([234,342],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([162,342],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.ground([378,414],1,0,-1)
    {
    }
   -Wire-([378,342],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([432,378],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.voltmetergnd([432,378],0,0,20)
    {
    Name = "Vcap"
    }
   0.sumjct([288,612],0,0,40)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.pgb([450,342],0,24913440,110)
    {
    Name = "capacitor voltage"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "2.0"
    }
   0.datalabel([450,342],0,0,-1)
    {
    Name = "Vcap"
    }
   0.datalabel([288,648],0,0,-1)
    {
    Name = "Vcap"
    }
   0.source_1([162,378],1,0,10)
    {
    Name = "Source1"
    Type = "6"
    Grnd = "1"
    Spec = "0"
    Cntrl = "0"
    AC = "0"
    Vm = "1 [kV]"
    Tc = "0.0 [s]"
    Ph = "0.0 [deg]"
    f = "60.0 [Hz]"
    P = "0.0 [MW]"
    Q = "0.0 [MVAR]"
    R = "0.001 [ohm]"
    Rs = "1.0 [ohm]"
    Rp = "1.0 [ohm]"
    Lp = "0.1 [H]"
    R' = "1.0 [ohm]"
    L = "0.1 [H]"
    C = "1.0 [uF]"
    L' = "0.1 [H]"
    C' = "1.0 [uF]"
    CUR = "i"
    }
   0.const([162,612],0,0,30)
    {
    Name = "Vsource"
    Value = "1.0"
    }
   0.inductor([234,342],2,0,-1)
    {
    L = "1 [H]"
    }
   0.pgb([468,792],0,24921680,100)
    {
    Name = "R"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "ohm"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "5.0"
    }
   0.datalabel([468,792],0,0,-1)
    {
    Name = "R"
    }
   -Wire-([324,792],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.annotation([396,792],0,0,-1)
    {
    AL1 = "x"
    AL2 = ""
    }
   0.capacitor([378,378],1,0,-1)
    {
    C = "1 [F]"
    }
   -SrcFile-([126,702],0)
    {
   Name = "golden_ise.emt\\optimumrun.out"
    }
   0.varrlc([324,342],2,0,120)
    {
    RLC = "0"
    R = "R"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.optimum_run([270,792],0,0,90)
    {
    OM = "1"
    NVR = "1"
    NVI = "1"
    NVB = "1"
    MRUNS = "42"
    TOL = "0.00001"
    Enab = "1"
    SM = "0"
    LHP = "0.01"
    RHP = "1000"
    SP = ""
    ISL = ""
    SEF = ""
    SIB = ""
    ISP = ""
    SRF = ""
    IC1 = ""
    IC2 = ""
    IC3 = ""
    IC4 = ""
    IC5 = ""
    IC6 = ""
    IC7 = ""
    IC8 = ""
    IC9 = ""
    IC10 = ""
    IC11 = ""
    IC12 = ""
    IC13 = ""
    IC14 = ""
    IC15 = ""
    IC16 = ""
    IC17 = ""
    IC18 = ""
    IC19 = ""
    IC20 = ""
    IP = ""
    PSG = ""
    PMP = ""
    BMR = ""
    RMR = ""
    PM = "1"
    LL1 = ""
    UL1 = ""
    LL2 = ""
    UL2 = ""
    LL3 = ""
    UL3 = ""
    LL4 = ""
    UL4 = ""
    LL5 = ""
    UL5 = ""
    LL6 = ""
    UL6 = ""
    LL7 = ""
    UL7 = ""
    LL8 = ""
    UL8 = ""
    LL9 = ""
    UL9 = ""
    LL10 = ""
    UL10 = ""
    BL1 = "1"
    BL2 = "1"
    BL3 = "1"
    BL4 = "1"
    BL5 = "1"
    BL6 = "1"
    BL7 = "1"
    BL8 = "1"
    BL9 = "1"
    BL10 = "1"
    Meas = "1"
    Fname = "optimumrun.out"
    }
   -Sticky-([288,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 288,18,900,72
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "Finding Optimum Value of Resistance Using Golden Section Optimization Method"
    }
   -Sticky-([630,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 630,108,1170,216
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
References:
1) A.M.Gole, S. Filizadeh, P.L. Wilson, \"Inclusion of Robustness into Design Using Optimization-Enabled Transient Simulation\"
2) A.M. Gole, S. Filizadeh, R.W. Menzies,  P.L. Wilson, \"Electromagnetic Transients Simulation as an Objective Function Evaluator for Optimization of Power System Performance\",  Proceedings, IPST'03 - International Conference ofn Power Systems Transients, New Orleans, September 28 - October 2, 2003
"
    }
   -ControlPanel-([630,252],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 630,252
    Extents = 0,0,144,126
    Meter(24921680)
    Meter(24906040)
    }
   -Plot-([630,396],0)
    {
    Title = ""
    Draw = 1
    Area = [0,0,540,450]
    Posn = [630,396]
    Icon = [-1,-1]
    Extents = 0,0,540,450
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,540,194],"Objective Function")
     {
     Options = 9
     Units = ""
     Curve(24906040,"objective function",8388608,,,)
     }
    Graph([0,194],[0,0,540,193],"Voltage")
     {
     Options = 9
     Units = "kV"
     Curve(24902888,"applied voltage",8388608,,,)
     Curve(24913440,"capacitor voltage",32768,,,)
     }
    }
   -Sticky-([54,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,108,576,180
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This project illustrates using Golden Section optimization algorithm to find the  optimum value of Resistance.

PSCAD project designed by: S. Filizadeh"
    }
   }
  }
 }

